Add-Type -AssemblyName System.Windows.Forms

$maxAttempts = 20
$delaySeconds = 10
$success = $false

for ($i = 1; $i -le $maxAttempts; $i++) {
    Write-Host "`n[$i. deneme] Azure AD Join komutu calistiriliyor..." -ForegroundColor Cyan
    dsregcmd /join

    Start-Sleep -Seconds $delaySeconds

    $status = dsregcmd /status
    if ($status -match "IsDeviceJoined\s*:\s*YES") {
        Write-Host "`n✅ Azure AD Join islemi basarili!" -ForegroundColor Green
        $success = $true
        break
    } else {
        Write-Host "❌ Azure AD Join henuz tamamlanmadi, tekrar deneniyor..." -ForegroundColor Yellow
    }
}

if ($success) {
    [System.Windows.Forms.MessageBox]::Show("Azure AD Join islemi BASARILI!", "Durum", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Information)
} else {
    [System.Windows.Forms.MessageBox]::Show("Azure AD Join islemi BASARILI oldu.", "Durum", [System.Windows.Forms.MessageBoxButtons]::OK, [System.Windows.Forms.MessageBoxIcon]::Error)
}
