# 💡 Turkce karakter destegi ve kodlama ayarlari
$PSDefaultParameterValues['Out-File:Encoding'] = 'utf8'
[console]::InputEncoding = [System.Text.Encoding]::UTF8
[console]::OutputEncoding = [System.Text.Encoding]::UTF8
chcp 65001 | Out-Null  # Konsolu UTF-8 moduna al

# 🛑 Yonetici olarak calistirilip calistirilmadigini kontrol et
$adminCheck = [System.Security.Principal.WindowsPrincipal] [System.Security.Principal.WindowsIdentity]::GetCurrent()
if (-not $adminCheck.IsInRole([System.Security.Principal.WindowsBuiltInRole] "Administrator")) {
    Write-Host "Script yonetici olarak yeniden baslatiliyor..." -ForegroundColor Yellow
    Start-Process PowerShell -ArgumentList "-NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs
    Exit
}

# 📝 Log dosyasi olustur
$logfile = "C:\TEMP\Kurulum_Log.txt"
"Kurulum basladi: $(Get-Date)" | Out-File -FilePath $logfile -Encoding utf8 -Append

############################################################
# 1️⃣ SCCM KURULUMU
############################################################
Write-Host "SCCM Client kurulumu baslatiliyor..." -ForegroundColor Cyan
$sccmPath = "C:\TEMP\2-Domainden sonra kurulacaklar\2-CCM son\ccmsetup.exe"

if (Test-Path $sccmPath) {
    try {
        Start-Process -FilePath $sccmPath -Verb RunAs -Wait
        Write-Host "SCCM Client kurulumu tamamlandi!" -ForegroundColor Green
        "SCCM kurulumu tamamlandi: $(Get-Date)" | Out-File -FilePath $logfile -Encoding utf8 -Append
    } catch {
        Write-Host "HATA: SCCM Client kurulamadi!" -ForegroundColor Red
        "HATA: SCCM Client kurulamadi: $(Get-Date)" | Out-File -FilePath $logfile -Encoding utf8 -Append
    }
} else {
    Write-Host "HATA: SCCM Client kurulum dosyasi bulunamadi!" -ForegroundColor Red
}

############################################################
# 2️⃣ TEAMVIEWER KURULUMU (Tam Senin Komutlarınla)
############################################################
Write-Host "TeamViewer kurulumu başlatılıyor..." -ForegroundColor Cyan

Start-Process -FilePath "cmd.exe" -ArgumentList "/c start /wait MSIEXEC.EXE /i `"C:\TEMP\2-Domainden sonra kurulacaklar\1-TeamViewer\TeamViewer_Host.msi`" /qn CUSTOMCONFIGID=qx5zq5v && timeout /t 30 /nobreak && `"C:\Program Files\TeamViewer\TeamViewer.exe`" assignment --id 0001CoABChCvZwgQjRgR7ZzvnMQSM7YLEigIACAAAgAJAK1Llbjp-X07cttUDxGCjISvWjzWWWjB5PaoDV0ruXBPGkDTZB54X5j3rt-mLZFnysyz5rIAOiSA9TOT72pE5KUK8syTSC0aMobt_D-SYUwKmuVjWhK8YMNUw6YZ7O8wa7_zIAEQyJfV7Ak=" -Wait -NoNewWindow

Write-Host "✅ TeamViewer kurulumu tamamlandı!" -ForegroundColor Green

############################################################
# 3️⃣ FORCEPOINT KURULUMU (Kesin Sessiz Kurulum)
############################################################
Write-Host "Forcepoint kurulumu baslatiliyor..." -ForegroundColor Cyan
"Forcepoint kurulumu baslatildi: $(Get-Date)" | Out-File -FilePath $logfile -Append
$forcepointPath = "C:\TEMP\2-Domainden sonra kurulacaklar\4-ForcePoint\ForcePoint_2411.exe"

if (Test-Path $forcepointPath) {
    Write-Host "Forcepoint sessiz kurulum baslatiliyor..." -ForegroundColor Yellow
    Start-Process -FilePath $forcepointPath -ArgumentList "/v`"/qn /norestart`"" -Wait -NoNewWindow

    # Kurulumun gercekten tamamlandigini kontrol et
    Start-Sleep -Seconds 10
    $installed = Get-WmiObject -Query "SELECT * FROM Win32_Product WHERE Name LIKE '%Forcepoint%'"

    if ($installed) {
        Write-Host "Forcepoint basariyla kuruldu!" -ForegroundColor Green
        "Forcepoint basariyla kuruldu: $(Get-Date)" | Out-File -FilePath $logfile -Append
    } else {
        Write-Host "HATA: Forcepoint kurulamadi!" -ForegroundColor Red
        "HATA: Forcepoint kurulamadi! $(Get-Date)" | Out-File -FilePath $logfile -Append
    }
} else {
    Write-Host "HATA: Forcepoint kurulum dosyasi bulunamadi!" -ForegroundColor Red
    "HATA: Forcepoint dosyasi eksik!" | Out-File -FilePath $logfile -Append
}

############################################################
# 4️⃣ BITLOCKER sİFRELEME VE KURTARMA ANAHTARI KAYDETME
############################################################
Write-Host "BitLocker sifreleme islemi baslatiliyor..." -ForegroundColor Cyan
$recoveryKeyPath = "$env:USERPROFILE\Desktop\BitLocker_Key.txt"

try {
    Enable-BitLocker -MountPoint "C:" -RecoveryPasswordProtector -UsedSpaceOnly -SkipHardwareTest -Confirm:$false
    Start-Sleep -Seconds 10
    $bitlockerRecoveryKey = (Get-BitLockerVolume -MountPoint "C:").KeyProtector | Where-Object { $_.KeyProtectorType -eq "RecoveryPassword" }

    if ($bitlockerRecoveryKey.RecoveryPassword) {
        # Anahtar dosyasini duzenli bir formatta kaydet
        @"
BitLocker Drive Encryption recovery key

To verify that this is the correct recovery key, compare the start of the following identifier with the identifier value displayed on your PC.

Identifier:
$($bitlockerRecoveryKey.KeyProtectorId)

If the above identifier matches the one displayed by your PC, then use the following key to unlock your drive.

Recovery Key:
$($bitlockerRecoveryKey.RecoveryPassword)

If the above identifier doesn't match the one displayed by your PC, then this isn't the right key to unlock your drive.
Try another recovery key, or refer to https://go.microsoft.com/fwlink/?LinkID=260589 for additional assistance.
"@ | Out-File -FilePath $recoveryKeyPath -Encoding utf8

        Write-Host "BitLocker etkinlestirildi! Kurtarma anahtari masaustune kaydedildi." -ForegroundColor Green
    }
} catch {
    Write-Host "HATA: BitLocker sifreleme islemi gerceklestirilemedi!" -ForegroundColor Red
}

############################################################
# 5️⃣ DEFENDER KURULUMU (CMD ADMIN OLARAK AÇILIR)
############################################################
Write-Host "Microsoft Defender for Endpoint kurulumu baslatiliyor..." -ForegroundColor Cyan
$defenderPath = "C:\TEMP\2-Domainden sonra kurulacaklar\4-Win. Defender(Admin kur).cmd"

if (Test-Path $defenderPath) {
    Write-Host "Defender kurulumu icin CMD Admin penceresi aciliyor..." -ForegroundColor Yellow
    Write-Host "NOT: Acilan pencerede Y + Enter yaparak kurulumu tamamlayin!" -ForegroundColor Green
    
    # CMD'yi yönetici olarak aç ve Defender path'ini çalıştır
    Start-Process -FilePath "cmd.exe" -ArgumentList "/k `"cd /d `"C:\TEMP\2-Domainden sonra kurulacaklar`" && `"4-Win. Defender(Admin kur).cmd`"`"" -Verb RunAs
    
    Write-Host "✅ Defender kurulum penceresi acildi!" -ForegroundColor Green
    "Defender kurulum penceresi acildi: $(Get-Date)" | Out-File -FilePath $logfile -Append
} else {
    Write-Host "HATA: Defender kurulum dosyasi bulunamadi!" -ForegroundColor Red
    "HATA: Defender dosyasi eksik!" | Out-File -FilePath $logfile -Append
}

############################################################
# ✅ KURULUM TAMAMLANDI
############################################################
Write-Host ""
Write-Host "Otomatik kurulumlar tamamlandi!"
Write-Host "Log dosyasi burada: $logfile" -ForegroundColor Magenta
Write-Host ""
Write-Host "NOT: Defender kurulumu manuel olarak devam ediyor!" -ForegroundColor Yellow
Write-Host "Acilan CMD penceresinde Y + Enter ile kurulumu tamamlayin." -ForegroundColor Cyan
Write-Host ""
Write-Host "Pencereyi kapatmak icin ENTER tusuna basin..."
Read-Host "Kapatmak icin Enter'a basin"